package w83b.w83bDAO;

import java.util.HashMap;

import w83b.w83bBeans.W83bArbitrosBean;
import w83b.w83bBeans.W83bConveniosBean;
import w83b.w83bBeans.W83bUsuarioXLNetsBean;


// TODO: Auto-generated Javadoc
/**
 * The Interface W83bIMantenimientosDAO.
 * @author a
 */
public interface W83bIMantenimientosDAO {
	
	/**
	 * Buscar agrupaciones.
	 * 
	 * @param param the param
	 * @return the java.util. list
	 * @throws Exception the exception
	 */
	public java.util.List buscarAgrupaciones(w83b.w83bBeans.W83bAgrupacionesBean param)throws Exception;
	
	/**
	 * Buscar convenio por agrupacion.
	 * 
	 * @param param the param
	 * @return the java.util. list
	 * @throws Exception the exception
	 */
	public java.util.List buscarConvenioPorAgrupacion(w83b.w83bBeans.W83bAgrupacionesBean param)throws Exception;
	
	/**
	 * Detalle agrupaciones.
	 * 
	 * @param param the param
	 * @return the w83b.w83b beans. w83b agrupaciones bean
	 * @throws Exception the exception
	 */
	public w83b.w83bBeans.W83bAgrupacionesBean detalleAgrupaciones(w83b.w83bBeans.W83bAgrupacionesBean param)throws Exception;
	
	/**
	 * Existe agrupacion.
	 * 
	 * @param codAgrupacion the cod agrupacion
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean existeAgrupacion(String codAgrupacion) throws Exception;
	
	/**
	 * Anyadir agrupaciones.
	 * 
	 * @param param the param
	 * @return the java.lang. string
	 * @throws Exception the exception
	 */
	public java.lang.String anyadirAgrupaciones(w83b.w83bBeans.W83bAgrupacionesBean param)throws Exception;
	
	/**
	 * Max cod agrupacion.
	 * 
	 * @return the string
	 * @throws Exception the exception
	 */
	public String maxCodAgrupacion()throws Exception;
	
	/**
	 * Contar agrupaciones.
	 * 
	 * @return the string
	 * @throws Exception the exception
	 */
	public String contarAgrupaciones()throws Exception;
	
	/**
	 * Modificar agrupaciones.
	 * 
	 * @param param the param
	 * @return the java.lang. string
	 * @throws Exception the exception
	 */
	public java.lang.String modificarAgrupaciones(w83b.w83bBeans.W83bAgrupacionesBean param)throws Exception;
	
	/**
	 * Borrar agrupaciones.
	 *
	 * @param param the param
	 * @param usuarioBean the usuario bean
	 * @return the java.lang. string
	 * @throws Exception the exception
	 * @throws RemoteException the remote exception
	 */
	public java.lang.String borrarAgrupaciones(java.util.ArrayList param,W83bUsuarioXLNetsBean usuarioBean) throws  java.lang.Exception, java.rmi.RemoteException;
	
	/**
	 * Buscar convenios.
	 * 
	 * @param param the param
	 * @return the java.util. list
	 * @throws Exception the exception
	 */
	public java.util.List buscarConvenios(w83b.w83bBeans.W83bConveniosBean param)throws Exception;	
	
	/**
	 * Anyadir convenios.
	 * 
	 * @param param the param
	 * @return the string
	 * @throws Exception the exception
	 */
	public String anyadirConvenios(W83bConveniosBean param)throws Exception;
	
	/**
	 * Max cod convenios.
	 * 
	 * @return the string
	 * @throws Exception the exception
	 */
	public String maxCodConvenios()throws Exception;
	
	/**
	 * Contar convenios.
	 * 
	 * @return the string
	 * @throws Exception the exception
	 */
	public String contarConvenios()throws Exception;

	/**
	 * Existe convenio.
	 * 
	 * @param codAgrupacion the cod agrupacion
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean existeConvenio(String codAgrupacion) throws Exception;
	
	/**
	 * Detalle convenios.
	 * 
	 * @param param the param
	 * @return the w83b.w83b beans. w83b convenios bean
	 * @throws Exception the exception
	 */
	public w83b.w83bBeans.W83bConveniosBean detalleConvenios(w83b.w83bBeans.W83bConveniosBean param)throws Exception;
	
	/**
	 * Modificar convenios.
	 * 
	 * @param param the param
	 * @return the java.lang. string
	 * @throws Exception the exception
	 */
	public java.lang.String modificarConvenios(w83b.w83bBeans.W83bConveniosBean param)throws Exception;
	
	/**
	 * Borrar convenios.
	 * 
	 * @param param the param
	 * @param usuarioBean the usuario bean
	 * @return the java.lang. string
	 * @throws Exception the exception
	 */
	public java.lang.String borrarConvenios(java.util.ArrayList param,W83bUsuarioXLNetsBean usuarioBean)throws Exception; 
	
	/**
	 * Borrar convenios individual.
	 * 
	 * @param param the param
	 * @param usuarioBean the usuario bean
	 * @return the java.lang. string
	 * @throws Exception the exception
	 */
	public java.lang.String borrarConveniosIndividual(java.lang.String param,W83bUsuarioXLNetsBean usuarioBean)throws Exception;
	
	/**
	 * Borrar convenios agrupacion.
	 * 
	 * @param param the param
	 * @param usuarioBean the usuario bean
	 * @return the java.lang. string
	 * @throws Exception the exception
	 */
	public java.lang.String borrarConveniosAgrupacion(java.util.ArrayList param,W83bUsuarioXLNetsBean usuarioBean)throws Exception; 
	
	/**
	 * Borrar convenios agrupacion cod agrupacion.
	 * 
	 * @param param the param
	 * @param usuarioBean the usuario bean
	 * @return the java.lang. string
	 * @throws Exception the exception
	 */
	public java.lang.String borrarConveniosAgrupacionCodAgrupacion(java.util.ArrayList param,W83bUsuarioXLNetsBean usuarioBean)throws Exception; 
	
	/**
	 * Asociar convenios.
	 * 
	 * @param idConvenio the id convenio
	 * @param idAgrupacion the id agrupacion
	 * @param usuarioBean the usuario bean
	 * @return the java.lang. string
	 * @throws Exception the exception
	 */
	public java.lang.String asociarConvenios(String idConvenio,String idAgrupacion,W83bUsuarioXLNetsBean usuarioBean)throws Exception;
	
	/**
	 * Existe convenio agrupacion.
	 * 
	 * @param idConvenio the id convenio
	 * @param idAgrupacion the id agrupacion
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean existeConvenioAgrupacion(String idConvenio,String idAgrupacion) throws Exception;
	
	/**
	 * Existe convenio agrupacion2.
	 *
	 * @param idConvenio the id convenio
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean existeConvenioAgrupacion2(String idConvenio) throws Exception;
	
	/**
	 * Existe convenio agrupacion.
	 * 
	 * @param idConvenio the id convenio
	 * @param codConvenio the cod convenio
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean existeConvenioAgrupacion(String idConvenio,boolean codConvenio) throws Exception;

	/**
	 * Buscar tipos voces.
	 * 
	 * @param param the param
	 * @return the java.util. list
	 * @throws Exception the exception
	 */
	public java.util.List buscarTiposVoces(w83b.w83bBeans.W83bTiposVocesBean param)throws Exception;
		
	/**
	 * Existe tipos voces.
	 * 
	 * @param codTipoVoz the cod tipo voz
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean existeTiposVoces(String codTipoVoz) throws Exception;
	
	/**
	 * Anyadir tipos voces.
	 * 
	 * @param param the param
	 * @return the java.lang. string
	 * @throws Exception the exception
	 */
	public java.lang.String anyadirTiposVoces(w83b.w83bBeans.W83bTiposVocesBean param)throws Exception;
	
	/**
	 * Max cod tipos voces.
	 * 
	 * @return the string
	 * @throws Exception the exception
	 */
	public String maxCodTiposVoces()throws Exception;
	
	/**
	 * Contar tipos voces.
	 * 
	 * @return the string
	 * @throws Exception the exception
	 */
	public String contarTiposVoces()throws Exception;
	
	/**
	 * Modificar tipos voces.
	 * 
	 * @param param the param
	 * @return the java.lang. string
	 * @throws Exception the exception
	 */
	public java.lang.String modificarTiposVoces(w83b.w83bBeans.W83bTiposVocesBean param)throws Exception;
	
	/**
	 * Detalle tipos voces.
	 * 
	 * @param param the param
	 * @return the w83b.w83b beans. w83b tipos voces bean
	 * @throws Exception the exception
	 */
	public w83b.w83bBeans.W83bTiposVocesBean detalleTiposVoces(w83b.w83bBeans.W83bTiposVocesBean param)throws Exception;
	
	/**
	 * Borrar tipos voces.
	 *
	 * @param param the param
	 * @param user the user
	 * @return the java.lang. string
	 * @throws Exception the exception
	 * @throws RemoteException the remote exception
	 */
	public java.lang.String borrarTiposVoces(java.util.ArrayList param, W83bUsuarioXLNetsBean user) throws  java.lang.Exception, java.rmi.RemoteException;
	
	/**
	 * Buscar delegaciones.
	 * 
	 * @param param the param
	 * @return the java.util. list
	 * @throws Exception the exception
	 */
	public java.util.List buscarDelegaciones(w83b.w83bBeans.W83bDelegacionesBean param)throws Exception;

	/**
	 * Detalle delegaciones.
	 * 
	 * @param param the param
	 * @return the w83b.w83b beans. w83b delegaciones bean
	 * @throws Exception the exception
	 */
	public w83b.w83bBeans.W83bDelegacionesBean detalleDelegaciones(w83b.w83bBeans.W83bDelegacionesBean param)throws Exception;
	
	/**
	 * Existe delegaciones.
	 * 
	 * @param codDelegacion the cod delegacion
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean existeDelegaciones(String codDelegacion) throws Exception;
	
	/**
	 * Anyadir delegaciones.
	 * 
	 * @param param the param
	 * @return the java.lang. string
	 * @throws Exception the exception
	 */
	public java.lang.String anyadirDelegaciones(w83b.w83bBeans.W83bDelegacionesBean param)throws Exception;
	
	/**
	 * Modificar delegaciones.
	 * 
	 * @param param the param
	 * @return the java.lang. string
	 * @throws Exception the exception
	 */
	public java.lang.String modificarDelegaciones(w83b.w83bBeans.W83bDelegacionesBean param)throws Exception;
	
	/**
	 * Buscar tramites.
	 * 
	 * @param param the param
	 * @return the java.util. list
	 * @throws Exception the exception
	 */
	public java.util.List buscarTramites(w83b.w83bBeans.W83bTramitesBean param)throws Exception;
	
	/**
	 * Modificar tramites.
	 * 
	 * @param param the param
	 * @return the java.lang. string
	 * @throws Exception the exception
	 */
	public java.lang.String modificarTramites(w83b.w83bBeans.W83bTramitesBean param)throws Exception;
	
	/**
	 * Detalle tramites.
	 * 
	 * @param param the param
	 * @return the w83b.w83b beans. w83b tramites bean
	 * @throws Exception the exception
	 */
	public w83b.w83bBeans.W83bTramitesBean detalleTramites(w83b.w83bBeans.W83bTramitesBean param)throws Exception;

	/**
	 * Buscar Plantillas.
	 * 
	 * @param param the param
	 * @return the java.util. list
	 * @throws Exception the exception
	 */
	public java.util.List buscarPlantillas(w83b.w83bBeans.W83bPlantillasBean param)throws Exception;
	
	/**
	 * Buscar Plantilla.
	 *
	 * @param nombrePlantilla the nombre plantilla
	 * @return the W83bPlantillasBean
	 * @throws Exception the exception
	 */
	public HashMap buscarPlantillas(java.util.List nombrePlantilla) throws Exception ;
	/**
	 * Detalle Plantillas.
	 * 
	 * @param param the param
	 * @return the w83b.w83bBeans.W83bPlantillasBean
	 * @throws Exception the exception
	 */
	public w83b.w83bBeans.W83bPlantillasBean detallePlantillas(w83b.w83bBeans.W83bPlantillasBean param)throws Exception;
	
	/**
	 * Modificar Plantillas.
	 * 
	 * @param param the param
	 * @return the java.lang.String
	 * @throws Exception the exception
	 */
	public java.lang.String modificarPlantillas(w83b.w83bBeans.W83bPlantillasBean param)throws Exception;
	
	/**
	 * Buscar voces.
	 * 
	 * @param param the param
	 * @return the java.util. list
	 * @throws Exception the exception
	 */
	public java.util.List buscarVoces(w83b.w83bBeans.W83bVocesBean param)throws Exception;
	
	/**
	 * Existe voces.
	 * 
	 * @param codVoz the cod voz
	 * @param codTvoz the cod tvoz
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean existeVoces(String codVoz, String codTvoz) throws Exception;
	
	/**
	 * Anyadir voces.
	 * 
	 * @param param the param
	 * @return the java.lang. string
	 * @throws Exception the exception
	 */
	public java.lang.String anyadirVoces(w83b.w83bBeans.W83bVocesBean param)throws Exception;
	
	/**
	 * Modificar voces.
	 * 
	 * @param param the param
	 * @return the java.lang. string
	 * @throws Exception the exception
	 */
	public java.lang.String modificarVoces(w83b.w83bBeans.W83bVocesBean param)throws Exception;
		
	/**
	 * Max cod voces.
	 * 
	 * @param param the param
	 * @return the string
	 * @throws Exception the exception
	 */
	public String maxCodVoces(String param)throws Exception;
	
	/**
	 * Detalle voces.
	 * 
	 * @param param the param
	 * @return the w83b.w83b beans. w83b voces bean
	 * @throws Exception the exception
	 */
	public w83b.w83bBeans.W83bVocesBean detalleVoces(w83b.w83bBeans.W83bVocesBean param)throws Exception;
	
	/**
	 * Borrar voces.
	 *
	 * @param param the param
	 * @param user the user
	 * @return the java.lang. string
	 * @throws Exception the exception
	 * @throws RemoteException the remote exception
	 */
	public java.lang.String borrarVoces(java.util.ArrayList param, W83bUsuarioXLNetsBean user) throws  java.lang.Exception, java.rmi.RemoteException;
	
	
	/**
	 * Buscar delegados.
	 *
	 * @param param the param
	 * @return the java.util. list
	 * @throws Exception the exception
	 */
	public java.util.List buscarDelegados(w83b.w83bBeans.W83bMantenimientoDelegadosBean param)throws Exception;
	
	/**
	 * Existe convenio actas.
	 * 
	 * @param idCodigo the id codigo
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean existeConvenioActas(String idCodigo) throws Exception;
	
	/**
	 * Existe convenio preavisos.
	 * 
	 * @param idCodigo the id codigo
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean existeConvenioPreavisos(String idCodigo) throws Exception;
	
	/**
	 * Existe convenio preavisos53.
	 * 
	 * @param idCodigo the id codigo
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean existeConvenioPreavisos53(String idCodigo) throws Exception;
	
	/**
	 * Buscar sindicatos.
	 * 
	 * @param param the param
	 * @return the java.util. list
	 * @throws Exception the exception
	 */
	public java.util.List buscarSindicatos(w83b.w83bBeans.W83bSindicatosBean param)throws Exception;
	
	/**
	 * Borrar sindicatos.
	 *
	 * @param param the param
	 * @param usuarioBean the usuario bean
	 * @return the java.lang. string
	 * @throws Exception the exception
	 * @throws RemoteException the remote exception
	 */
	public java.lang.String borrarSindicatos(java.util.ArrayList param,W83bUsuarioXLNetsBean usuarioBean) throws  java.lang.Exception, java.rmi.RemoteException;
	
	/**
	 * Max cod sindicato.
	 * 
	 * @return the string
	 * @throws Exception the exception
	 */
	public String maxCodSindicato()throws Exception;
	
	/**
	 * Contar sindicatos.
	 * 
	 * @return the string
	 * @throws Exception the exception
	 */
	public String contarSindicatos()throws Exception;
	
	/**
	 * Existe sindicato.
	 * 
	 * @param codAgrupacion the cod agrupacion
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean existeSindicato(String codAgrupacion) throws Exception;
	
	/**
	 * Anyadir sindicato.
	 * 
	 * @param param the param
	 * @return the java.lang. string
	 * @throws Exception the exception
	 */
	public java.lang.String anyadirSindicato(w83b.w83bBeans.W83bSindicatosBean param)throws Exception;
	
	/**
	 * Detalle sindicatos.
	 * 
	 * @param param the param
	 * @return the w83b.w83b beans. w83b sindicatos bean
	 * @throws Exception the exception
	 */
	public w83b.w83bBeans.W83bSindicatosBean detalleSindicatos(w83b.w83bBeans.W83bSindicatosBean param)throws Exception;
	
	/**
	 * Modificar sindicatos.
	 * 
	 * @param param the param
	 * @return the java.lang. string
	 * @throws Exception the exception
	 */
	public java.lang.String modificarSindicatos(w83b.w83bBeans.W83bSindicatosBean param)throws Exception;
	
	
	
	/**
	 * Buscar usuarios.
	 * 
	 * @param param the param
	 * @return the java.util. list
	 * @throws Exception the exception
	 */
	public java.util.List buscarUsuarios(w83b.w83bBeans.W83bUsuariosBean param)throws Exception;
	
	/**
	 * Detalle usuarios.
	 * 
	 * @param param the param
	 * @return the w83b.w83b beans. w83b usuarios bean
	 * @throws Exception the exception
	 */
	public w83b.w83bBeans.W83bUsuariosBean detalleUsuarios(w83b.w83bBeans.W83bUsuariosBean param)throws Exception;
	
	/**
	 * Modificar usuarios.
	 * 
	 * @param param the param
	 * @return the java.lang. string
	 * @throws Exception the exception
	 */
	public java.lang.String modificarUsuarios(w83b.w83bBeans.W83bUsuariosBean param)throws Exception;
	/**
	 * Borrar usuarios.
	 * 
	 * @param param the param
	 * @return the java.lang. string
	 * @throws Exception the exception
	 */
	public String borrarUsuarios(w83b.w83bBeans.W83bUsuariosBean param)throws Exception;
	/**
	 * Anyadir usuario.
	 * 
	 * @param param the param
	 * @return the java.lang. string
	 * @throws Exception the exception
	 */
	public String anyadirUsuario(w83b.w83bBeans.W83bUsuariosBean param)	throws Exception ;
	/**
	 * Buscar centro trabajo.
	 * 
	 * @param param the param
	 * @return the java.util. list
	 * @throws Exception the exception
	 */
	public java.util.List buscarCentroTrabajo(w83b.w83bBeans.W83bCentroTrabajoBean param)throws Exception;
	
	/**
	 * Contar centro trabajo.
	 * 
	 * @param param the param
	 * @return the int
	 * @throws Exception the exception
	 */
	public int contarCentroTrabajo(w83b.w83bBeans.W83bCentroTrabajoBean param) throws Exception;
	
	/**
	 * Buscar comarca.
	 * 
	 * @param codProvincia the cod provincia
	 * @param codMunicipio the cod municipio
	 * @return the java.util. list
	 * @throws Exception the exception
	 */
	public java.util.List buscarComarca(String codProvincia, String codMunicipio) throws Exception;
	
	/**
	 * Cargar cnae.
	 * 
	 * @param mapaResultado the mapa resultado
	 * @return the java.util. list
	 * @throws Exception the exception
	 */
	public java.util.List cargarCnae(HashMap mapaResultado) throws Exception;
	
	/**
	 * Cargar cnae codigo.
	 * 
	 * @param codigo the codigo
	 * @return the java.util. list
	 * @throws Exception the exception
	 */
	public java.util.List cargarCnaeCodigo(String codigo) throws Exception;
	
	/**
	 * Max cod centro trabajo.
	 * 
	 * @return the string
	 * @throws Exception the exception
	 */
	public String maxCodCentroTrabajo() throws Exception;
	
	/**
	 * Existe cod centro trabajo.
	 * 
	 * @param codCentroTrabajo the cod centro trabajo
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean existeCodCentroTrabajo(String codCentroTrabajo) throws Exception;
	
	/**
	 * Existe centro trabajo.
	 * 
	 * @param cifNifCentroTrabajo the cif nif centro trabajo
	 * @param codCentro the cod centro
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean existeCentroTrabajo(String cifNifCentroTrabajo,String codCentro) throws Exception;
	
	/**
	 * Anyadir centro trabajo.
	 * 
	 * @param param the param
	 * @return the java.lang. string
	 * @throws Exception the exception
	 */
	public java.lang.String anyadirCentroTrabajo(w83b.w83bBeans.W83bCentroTrabajoBean param)throws Exception;
	
	/**
	 * Detalle centro trabajo.
	 * 
	 * @param cifnif the cifnif
	 * @param nCentroTrabajo the n centro trabajo
	 * @param idioma the idioma
	 * @return the java.util. list
	 * @throws Exception the exception
	 */
	public java.util.List detalleCentroTrabajo(String cifnif, String nCentroTrabajo,String idioma) throws Exception;

	/**
	 * Buscar motivos baja delegado.
	 * 
	 * @param param the param
	 * @return the java.util. list
	 * @throws Exception the exception
	 */
	public java.util.List buscarMotivosBajaDelegado(w83b.w83bBeans.W83bMotivosBajaDelegadoBean param)throws Exception;
	
	/**
	 * Max cod motivo baja delegado.
	 * 
	 * @return the string
	 * @throws Exception the exception
	 */
	public String maxCodMotivoBajaDelegado()throws Exception;
	
	/**
	 * Contar motivos baja delegado.
	 * 
	 * @return the string
	 * @throws Exception the exception
	 */
	public String contarMotivosBajaDelegado()throws Exception;
	
	/**
	 * Existe motivo baja delegado.
	 * 
	 * @param codMotivo the cod motivo
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean existeMotivoBajaDelegado(String codMotivo) throws Exception;
	
	/**
	 * Anyadir motivo baja delegado.
	 * 
	 * @param param the param
	 * @return the java.lang. string
	 * @throws Exception the exception
	 */
	public java.lang.String anyadirMotivoBajaDelegado(w83b.w83bBeans.W83bMotivosBajaDelegadoBean param)throws Exception;
	
	/**
	 * Modificar motivo baja delegado.
	 * 
	 * @param param the param
	 * @return the java.lang. string
	 * @throws Exception the exception
	 */
	public java.lang.String modificarMotivoBajaDelegado(w83b.w83bBeans.W83bMotivosBajaDelegadoBean param)throws Exception;
	
	/**
	 * Detalle motivo baja delegado.
	 * 
	 * @param param the param
	 * @return the w83b.w83b beans. w83b motivos baja delegado bean
	 * @throws Exception the exception
	 */
	public w83b.w83bBeans.W83bMotivosBajaDelegadoBean detalleMotivoBajaDelegado(w83b.w83bBeans.W83bMotivosBajaDelegadoBean param)throws Exception;
	
	/**
	 * Buscar empresas.
	 * 
	 * @param param the param
	 * @return the java.util. list
	 * @throws Exception the exception
	 */
	public java.util.List buscarEmpresas(w83b.w83bBeans.W83bEmpresasBean param) throws Exception;
	
	/**
	 * Detalle empresas.
	 * 
	 * @param param the param
	 * @return the w83b.w83b beans. w83b empresas bean
	 * @throws Exception the exception
	 */
	public w83b.w83bBeans.W83bEmpresasBean detalleEmpresas(w83b.w83bBeans.W83bEmpresasBean param) throws Exception;
	
	/**
	 * Anyadir empresas.
	 * 
	 * @param param the param
	 * @return the java.lang. string
	 * @throws Exception the exception
	 */
	public java.lang.String anyadirEmpresas(w83b.w83bBeans.W83bEmpresasBean param) throws Exception;
	
	/**
	 * Modificar empresas.
	 * 
	 * @param param the param
	 * @return the java.lang. string
	 * @throws Exception the exception
	 */
	public java.lang.String modificarEmpresas(w83b.w83bBeans.W83bEmpresasBean param) throws Exception;
	
	/**
	 * Max cod empresa.
	 * 
	 * @return the string
	 * @throws Exception the exception
	 */
	public String maxCodEmpresa()throws Exception;
	
	/**
	 * Contar empresas.
	 * 
	 * @return the string
	 * @throws Exception the exception
	 */
	public String contarEmpresas()throws Exception;
	
	/**
	 * Existe empresa.
	 * 
	 * @param codEmpresa the cod empresa
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean existeEmpresa(String codEmpresa) throws Exception;
	
	/**
	 * Buscar resp area.
	 * 
	 * @param param the param
	 * @return the java.util. list
	 * @throws Exception the exception
	 */
	public java.util.List buscarRespArea(w83b.w83bBeans.W83bRespAreaBean param) throws Exception;	
	
	/**
	 * Detalle resp area.
	 * 
	 * @param param the param
	 * @return the w83b.w83b beans. w83b resp area bean
	 * @throws Exception the exception
	 */
	public w83b.w83bBeans.W83bRespAreaBean detalleRespArea(w83b.w83bBeans.W83bRespAreaBean param) throws Exception;
	
	/**
	 * Anyadir resp area.
	 * 
	 * @param param the param
	 * @return the java.lang. string
	 * @throws Exception the exception
	 */
	public java.lang.String anyadirRespArea(w83b.w83bBeans.W83bRespAreaBean param) throws Exception;
	
	/**
	 * Modificar resp area.
	 * 
	 * @param param the param
	 * @return the java.lang. string
	 * @throws Exception the exception
	 */
	public java.lang.String modificarRespArea(w83b.w83bBeans.W83bRespAreaBean param) throws Exception;
	
	/**
	 * Existe territorio.
	 * 
	 * @param codTerritorio the cod territorio
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean existeTerritorio(String codTerritorio) throws Exception;
	
	
	/**
	 * Existe provincia perfil.
	 *
	 * @param codTerritorio the cod territorio
	 * @param codPerfil the cod perfil
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean existeProvinciaPerfil(String codTerritorio, String codPerfil) throws Exception;
	
	/**
	 * Existe provincia perfil.
	 *
	 * @param codTerritorio the cod territorio
	 * @param codPerfil the cod perfil
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean existeProvinciaPerfilNoActual(String codTerritorio, String codPerfil,String codResponsable) throws Exception;
	
	/**
	 * Contar responsables area.
	 *
	 * @return the string
	 * @throws Exception the exception
	 */
	public String contarResponsablesArea()throws Exception;
	
	/**
	 * Borrar resp area.
	 *
	 * @param param the param
	 * @param usuarioBean the usuario bean
	 * @return the java.lang. string
	 * @throws Exception the exception
	 * @throws RemoteException the remote exception
	 */
	public java.lang.String borrarRespArea(java.util.ArrayList param,W83bUsuarioXLNetsBean usuarioBean) throws  java.lang.Exception, java.rmi.RemoteException;
	
	/**
	 * Buscar motivos baja acta.
	 * 
	 * @param param the param
	 * @return the java.util. list
	 * @throws Exception the exception
	 */
	public java.util.List buscarMotivosBajaActa(w83b.w83bBeans.W83bMotivosBajaActaBean param)throws Exception;
	
	/**
	 * Max cod motivo baja acta.
	 * 
	 * @return the string
	 * @throws Exception the exception
	 */
	public String maxCodMotivoBajaActa()throws Exception;
	
	/**
	 * Contar motivos baja acta.
	 * 
	 * @return the string
	 * @throws Exception the exception
	 */
	public String contarMotivosBajaActa()throws Exception;
	
	/**
	 * Existe motivo baja acta.
	 * 
	 * @param codMotivo the cod motivo
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean existeMotivoBajaActa(String codMotivo) throws Exception;
	
	/**
	 * Anyadir motivo baja acta.
	 * 
	 * @param param the param
	 * @return the java.lang. string
	 * @throws Exception the exception
	 */
	public java.lang.String anyadirMotivoBajaActa(w83b.w83bBeans.W83bMotivosBajaActaBean param)throws Exception;
	
	/**
	 * Modificar motivo baja acta.
	 * 
	 * @param param the param
	 * @return the java.lang. string
	 * @throws Exception the exception
	 */
	public java.lang.String modificarMotivoBajaActa(w83b.w83bBeans.W83bMotivosBajaActaBean param)throws Exception;
	
	/**
	 * Detalle motivo baja acta.
	 * 
	 * @param param the param
	 * @return the w83b.w83b beans. w83b motivos baja acta bean
	 * @throws Exception the exception
	 */
	public w83b.w83bBeans.W83bMotivosBajaActaBean detalleMotivoBajaActa(w83b.w83bBeans.W83bMotivosBajaActaBean param)throws Exception;
	
	/**
	 * Buscar arbitros.
	 * 
	 * @param param the param
	 * @return the java.util. list
	 * @throws Exception the exception
	 */
	public java.util.List buscarArbitros(w83b.w83bBeans.W83bArbitrosBean param) throws Exception;	
	
	/**
	 * Detalle arbitro.
	 * 
	 * @param param the param
	 * @return the w83b.w83b beans. w83b arbitros bean
	 * @throws Exception the exception
	 */
	public w83b.w83bBeans.W83bArbitrosBean detalleArbitro(w83b.w83bBeans.W83bArbitrosBean param) throws Exception;
	
	/**
	 * Anyadir arbitro.
	 * 
	 * @param param the param
	 * @return the java.lang. string
	 * @throws Exception the exception
	 */
	public java.lang.String anyadirArbitro(w83b.w83bBeans.W83bArbitrosBean param) throws Exception;
	
	/**
	 * Modificar arbitro.
	 * 
	 * @param paramTemp the param temp
	 * @param paramNuevo the param nuevo
	 * @return the java.lang. string
	 * @throws Exception the exception
	 */
	public java.lang.String modificarArbitro(w83b.w83bBeans.W83bArbitrosBean paramTemp, w83b.w83bBeans.W83bArbitrosBean paramNuevo) throws Exception;
	
	/**
	 * Borrar arbitro.
	 *
	 * @param param the param
	 * @param usuarioBean the usuario bean
	 * @return the java.lang. string
	 * @throws Exception the exception
	 * @throws RemoteException the remote exception
	 */
	public java.lang.String borrarArbitro(java.util.ArrayList param,W83bUsuarioXLNetsBean usuarioBean) throws  java.lang.Exception, java.rmi.RemoteException;
	
	/**
	 * Existe arbitro.
	 * 
	 * @param param the param
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean existeArbitro(w83b.w83bBeans.W83bArbitrosBean param) throws Exception;
	
	/**
	 * Existe motivo acta.
	 * 
	 * @param idMotivo the id motivo
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean existeMotivoActa(String idMotivo) throws Exception;
	
	/**
	 * Borrar motivo acta.
	 * 
	 * @param idMotivo the id motivo
	 * @param usuarioBean the usuario bean
	 * @return the java.lang. string
	 * @throws Exception the exception
	 */
	public java.lang.String borrarMotivoActa(java.util.ArrayList  idMotivo,W83bUsuarioXLNetsBean usuarioBean) throws Exception;
	
	/**
	 * Existe motivo delegado.
	 *
	 * @param idMotivo the id motivo
	 * @param usuarioBean the usuario bean
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean existeMotivoDelegado(String idMotivo,W83bUsuarioXLNetsBean usuarioBean) throws Exception;
	
	/**
	 * Borrar motivo delegado.
	 * 
	 * @param idMotivo the id motivo
	 * @param usuarioBean the usuario bean
	 * @return the java.lang. string
	 * @throws Exception the exception
	 */
	public java.lang.String borrarMotivoDelegado(java.util.ArrayList  idMotivo,W83bUsuarioXLNetsBean usuarioBean) throws Exception;
	
	/**
	 * Existe empresa convenio.
	 * 
	 * @param idEmpresa the id empresa
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean existeEmpresaConvenio(String idEmpresa) throws Exception;
	
	/**
	 * Borrar empresas.
	 * 
	 * @param param the param
	 * @param usuarioBean the usuario bean
	 * @return the java.lang. string
	 * @throws Exception the exception
	 */
	public java.lang.String borrarEmpresas(java.lang.String param,W83bUsuarioXLNetsBean usuarioBean)throws Exception;
	
	/**
	 * Existe sindicato asociacion.
	 *
	 * @param idSindicato the id sindicato
	 * @param usuarioBean the usuario bean
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean existeSindicatoAsociacion(String idSindicato,W83bUsuarioXLNetsBean usuarioBean) throws Exception;

	/**
	 * Existe dni.
	 * 
	 * @param paramTemp the param temp
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean existeDni(W83bArbitrosBean paramTemp)throws Exception;
	
	/**
	 * Devolver num centro cod centro.
	 *
	 * @param param the param
	 * @return the list
	 * @throws Exception the exception
	 */
	public java.util.List devolverNumCentroCodCentro(w83b.w83bBeans.W83bCentroTrabajoBean param) throws Exception;
	
}
